<?php

use com\cminds\rssaggregator\App;
use com\cminds\rssaggregator\plugin\options\Options;
use com\cminds\rssaggregator\plugin\helpers\HTMLHelper;
use com\cminds\rssaggregator\plugin\shortcodes\Shortcode;
use com\cminds\rssaggregator\plugin\misc\UserAgents;
?>
<div class="clear"></div>
<hr />

<?php
 echo do_shortcode(sprintf('[cminds_free_guide]', App::SLUG));
?>

<div class="cmra">
    <?php
    /*
      <div class="card">
      <h2>Shortcodes</h2>
      <ol>
      <li>
      to display list use
      <code>[<?php echo Shortcode::SHORTCODE; ?>]</code> with <code>list</code>, <code>category</code> and <code>tag</code> attributes (you can use then at the same time to customize your list &mdash; they works like filters) where:
      <ul>
      <li>
      <code>list</code> is slug or list of slugs of <a href="edit-tags.php?taxonomy=cmra_list">lists</a>, e.g.: <code>[<?php echo Shortcode::SHORTCODE; ?> list=list1,list2,...]</code>,
      </li>
      <li>
      <code>category</code> is slug or list of slugs of <a href="edit-tags.php?taxonomy=cmra_category">categories</a>, e.g.: <code>[<?php echo Shortcode::SHORTCODE; ?> category=category1,category2,...]</code>,
      </li>
      <li>
      <code>tag</code> is slug or list of slugs of <a href="edit-tags.php?taxonomy=cmra_tag">tags</a>, e.g.: <code>[<?php echo Shortcode::SHORTCODE; ?> tag=tag1,tag2,...]</code>,
      </li>
      </ul>
      </li>
      <li>
      to display single category (without search and filter on the top of the list) use
      <code>[<?php echo Shortcode::SHORTCODE; ?> category=category1]</code> where <code>category</code> attribute is slug of the <a href="edit-tags.php?taxonomy=cmra_category">category</a>.
      </li>
      </ol>
      <p>
      To overwrite global setting of max number of links use <code>max_links</code> attribute (set 0 to remove limit) e.g.: <code>[<?php echo Shortcode::SHORTCODE; ?> category=category1 max_links=10]</code>.
      </p>
      </div>
     *
     */
    ?>
    <h2 class="nav-tab-wrapper">
        <a href="#cmra-tab-plugin-options" data-for="general-options" class="nav-tab">Plugin Options</a>
        <!-- <a href="#cmra-tab-plugin-appearance" data-for="plugin-appearance" class="nav-tab">Plugin Appearance</a> -->
        <a href="#cmra-tab-plugin-diagnostics" data-for="plugin-diagnostics" class="nav-tab" style="float: right;"><small>Plugin Diagnostics</small></a>
    </h2>
    <form method="post">
        <div data-role="tab" data-tab="general-options" style="display: none;">
            <h3>General</h3>
            <table class="form-table">
                <tr>
                    <th scope="row"><label for="columns_count">Number of columns *</label></th>
                    <td>
                        <input name="columns_count" type="number" min="1" max="10" id="columns_count" value="<?php echo intval(Options::getOption('columns_count')); ?>" class="regular-text" required="required">
                        <p class="description">Number of columns generated by plugin.</p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="max_number_of_links">Max number of links</label></th>
                    <td>
                        <input name="max_number_of_links" type="number" min="0" id="max_number_of_links" value="<?php echo intval(Options::getOption('max_number_of_links')) ?: ''; ?>" class="regular-text">
                        <p class="description">Max number of links displayed in categories.<br />Leave empty to remove limit.</p>
                    </td>
                </tr>
                <!--
                <tr>
                    <th scope="row"><label for="favicons_local_cache">Favicons local cache</label></th>
                    <td>
                        <input type="checkbox" id="favicons_local_cache" onchange="jQuery(this).next().val(this.checked ? 1 : 0)" <?php echo intval(Options::getOption('favicons_local_cache')) ? 'checked="checked"' : ''; ?> />
                        <input type="hidden" name="favicons_local_cache" value="<?php echo intval(Options::getOption('favicons_local_cache')); ?>" />
                        <p class="description">
                            Images with favicons will be locally saved as attached - this options <strong>is not</strong> recommend if you curate large lists (may cause performance issues).
                            <br />
                            Favicon for link is cached during adding or updating link entry.
                        </p>
                    </td>
                </tr>
                -->
                <tr>
                    <th scope="row"><label for="links_rel_nofollow">No follow</label></th>
                    <td>
                        <input type="checkbox" id="links_rel_nofollow" onchange="jQuery(this).next().val(this.checked ? 1 : 0)" <?php echo intval(Options::getOption('links_rel_nofollow')) ? 'checked="checked"' : ''; ?> />
                        <input type="hidden" name="links_rel_nofollow" value="<?php echo intval(Options::getOption('links_rel_nofollow')); ?>" />
                        <p class="description">
                            <code>rel="nofollow"</code> will be added to links.
                        </p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="links_target_blank">Open in a new window or tab</label></th>
                    <td>
                        <input type="checkbox" id="links_target_blank" onchange="jQuery(this).next().val(this.checked ? 1 : 0)" <?php echo intval(Options::getOption('links_target_blank')) ? 'checked="checked"' : ''; ?> />
                        <input type="hidden" name="links_target_blank" value="<?php echo intval(Options::getOption('links_target_blank')); ?>" />
                        <p class="description">
                            Linked documents will be opened in a new window or tab.
                        </p>
                    </td>
                </tr>

                <tr>
                    <th scope="row"><label for="show_tooltips">Show tooltips</label></th>
                    <td>
                        <input type="checkbox" id="show_tooltips" onchange="jQuery(this).next().val(this.checked ? 1 : 0)" <?php echo intval(Options::getOption('show_tooltips')) ? 'checked="checked"' : ''; ?> />
                        <input type="hidden" name="show_tooltips" value="<?php echo intval(Options::getOption('show_tooltips')); ?>" />
                        <p class="description">
                            Show tooltips with description on links hover.
                        </p>
                    </td>
                </tr>

                <tr>
                    <th scope="row"><label for="show_dates">Show dates</label></th>
                    <td>
                        <input type="checkbox" id="show_dates" onchange="jQuery(this).next().val(this.checked ? 1 : 0)" <?php echo intval(Options::getOption('show_dates')) ? 'checked="checked"' : ''; ?> />
                        <input type="hidden" name="show_dates" value="<?php echo intval(Options::getOption('show_dates')); ?>" />
                        <p class="description">
                            Show dates under links.
                        </p>
                    </td>
                </tr>
            </table>

        </div>

        <div id="cmra-form-submit" style="display: none;">
            <input type="hidden" name="cmra_action_update" value="1" />
            <input type="hidden" name="nonce" value="<?php echo wp_create_nonce('cmra_action_update'); ?>" />
            <?php submit_button(); ?>
            <small>* - required fields</small>
        </div>
    </form>
    <div data-role="tab" data-tab="plugin-diagnostics" style="display: none;">
        <?php do_action('cmra_options_diagnostic_tab'); ?>
    </div>
</div>

<style type="text/css">
    .cmra h2.nav-tab-wrapper{
        margin-top: 20px;
    }
    .cmra .nav-tab{
        box-shadow: none;
    }
    .cmra .card{
        max-width: none;
    }
</style>
<script type="text/javascript">
    (function ($) {
        "use strict";
        $('.cmra .nav-tab').on('click', function () {
            $('.cmra .nav-tab').removeClass('nav-tab-active');
            $(this).addClass('nav-tab-active');
            $('.cmra *[data-role="tab"]').hide();
            $('.cmra *[data-role="tab"][data-tab="' + $(this).data('for') + '"]').show();
            if ($(this).data('for') == 'plugin-diagnostics') {
                $('#cmra-form-submit').hide();
            } else {
                $('#cmra-form-submit').show();
            }
        });
        if ($('.cmra a[href="' + window.location.hash + '"]').click().length != 1) {
            $('.cmra a.nav-tab').first().click();
        }
        $('.cmra input[type="submit"]').on('click', function () {
            if ($('.cmra form').find(':invalid')) {
                var tab = $('.cmra form').find(':invalid').first().parents('*[data-role="tab"]').data('tab');
                $('.cmra').find('a[data-for="' + tab + '"]').click();
            }
        });
    })(jQuery);
</script>
